/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.security;

import de.willuhn.logging.Logger;
import java.util.HashMap;

public class Principal {
    public static final String DISTINGUISHED_NAME = "DN";
    public static final String COMMON_NAME = "CN";
    public static final String ORGANIZATION = "O";
    public static final String ORGANIZATIONAL_UNIT = "OU";
    public static final String LOCALITY = "L";
    public static final String STATE = "ST";
    public static final String COUNTRY = "C";
    private java.security.Principal p = null;
    private HashMap<String, String> attributes = new HashMap();

    public Principal(java.security.Principal p) {
        this.p = p;
        this.attributes.put(DISTINGUISHED_NAME, this.p.getName());
        String s = this.p.getName();
        if (s == null || s.length() == 0) {
            return;
        }
        String[] items = s.split(",(?=([^\"]*\"[^\"]*\")*(?![^\"]*\"))");
        if (items == null || items.length < 1) {
            Logger.warn((String)("this seems not to be a valid X.500 name: " + s));
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            String token = items[i];
            if (token == null || token.indexOf(61) == -1) {
                Logger.info((String)("unable to parse attribute " + token + ", skipping"));
                continue;
            }
            String[] pair = token.trim().split("=");
            if (pair.length != 2 || pair[1] == null || pair[1].length() == 0) continue;
            this.attributes.put(pair[0].toUpperCase(), pair[1]);
        }
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }
}

